/* eslint-disable max-len */
// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'backbone',
    'marionette',
    'modules/new-appointment-wizard/wizard-section-view',
    'json!modules/community-care-request/new-appointment-request-question/facility-caretype-selection/community-care-facility-caretype.json',
    'text!modules/community-care-request/new-appointment-request-question/facility-caretype-selection/facility-section-template.html',
    'text!modules/community-care-request/new-appointment-request-question/facility-caretype-selection/single-facility-section-template.html',
],
function (_, Backbone, Marionette, WizardSectionView, metadata, facilitySectionTemplate, singleFacilitySectionTemplate) {
    'use strict';

    return WizardSectionView.extend({
        initialize: function(options) {
            var sectionName = options.hasMultiFacilities ? 'facility-section' : 'single-facility-section';
            var facilities;
            var facilityModel;
            var supportedFacilitiesForPatient;

            this._initializeSection(options, sectionName, metadata, options.step);
            this.initializeQuestionEventListeners();
            this.patientEnrolledFacilities = options.patientEnrolledFacilities;
            this.wizardModel = options.model;
            facilityModel = this.wizardModel.get('facility');

            // we reset this.model b/c by default when passed in as an option, Backbone will set this.model to options.model
            this.model = new Backbone.Model();

            if (options.hasMultiFacilities) {
                facilities = [];
                this.patientEnrolledFacilities.each(function (facility) {
                    facilities.push({
                        id: facility.get('facilityCode'),
                        text: _.template(facilitySectionTemplate)(facility.toJSON()),
                        value: facility.get('facilityCode'),
                        disabled: !facility.get('supportsVAR'),
                        selected: facilityModel && facilityModel.get('facilityCode') === facility.get('facilityCode'),
                    });
                });
                this.collection.get('facility').set('values', facilities);
            } else {
                this.collection.get('facility').set('template', singleFacilitySectionTemplate);
            }

            supportedFacilitiesForPatient = this.patientEnrolledFacilities.where({ supportsVAR: true });

            // when: there is only 1 VAR supporting facility
            // then: force selection of the one facility
            if (supportedFacilitiesForPatient.length === 1) {
                this.wizardModel.set('facility', supportedFacilitiesForPatient[0]);

                // when: there are multiple facilities associated with the user, (even though only 1 supports VAR)
                // then: we set the facility ui to be the siteCode (e.g. selects the radio button)
                // else: we set the facility ui model to be the name
                if (options.hasMultiFacilities) {
                    this.model.set('facility', supportedFacilitiesForPatient[0].get('facilityCode'));
                } else {
                    this.model.set('facility', supportedFacilitiesForPatient[0].get('name'));
                }
            }
        },
        modelEvents: {'change:facility': 'handleFacilityChange'},
        handleFacilityChange: function() {
            var selectedFacility = this.patientEnrolledFacilities.findWhere({ facilityCode: this.model.get('facility') });
            this.wizardModel.set('facility', selectedFacility);
        },
    });
});
